% ALPHA ENGINE DEFINITION
% Generated 12-Jun-2018 12:46:31

% SUGGESTED CITATION:
% 2014 Chevrolet 4.3L EcoTec3 LV3 Engine LEV III Fuel - ALPHA Map Package. Version 2018-06. Ann Arbor MI: US EPA National Vehicle and Fuel Emissions Laboratory, National Center for Advanced Technology, 2018.


% Constructor
engine = class_REVS_engine();
engine.name =  '2014 Chevrolet 4.3L EcoTec3 LV3 Engine LEV III Fuel'; 
engine.source_filename = mfilename;engine.matrix_vintage = enum_matrix_vintage.present;

% Physical Description
engine.displacement_L =  4.3; 
engine.num_cylinders =  6; 
engine.combustion_type = enum_engine_combustion_type.spark_ignition;
engine.bore_mm =  99.6; 
engine.stroke_mm =  92; 

% Maximum Torque Curve
engine.full_throttle_speed_radps = [	    0.00000000000000000	;     83.775804095727807	;     104.71975511965977	;     167.55160819145561	;     209.43951023931953	;     251.32741228718345	;     335.10321638291123	;     376.99111843077515	;     408.40704496667308	;     460.76692252650298	;     534.07075111026484	;     575.95865315812875	;     604.75658581603523	;     633.55451847394170		]; 
engine.full_throttle_torque_Nm = [	    0.00000000000000000	;     271.16359999999997	;     305.05905000000001	;     328.10795600000000	;     359.29176999999999	;     379.62903999999997	;     386.40812999999997	;     406.74540000000002	;     413.52449000000001	;     406.74540000000002	;     393.18721999999997	;     366.07085999999998	;     313.77502285714286	;    0.00000000000000000		]; 

% Minimum Torque Curve
engine.closed_throttle_speed_radps = [	    0.00000000000000000	;     83.775804095727807	;     104.71975511965977	;     261.79938779914943	;     633.55451847394170		]; 
engine.closed_throttle_torque_Nm = [	    -32.700000000000003	;    -39.100000000000001	;    -41.500000000000000	;    -52.700000000000003	;    -81.100000000000023		]; 

% Fuel Map
engine.fuel_map_speed_radps = [	    0.00000000000000000	;     30.768908048908607	;     61.537816097817213	;     83.775804095727807	;     104.06839824281546	;     115.75157855322699	;     131.11541659512119	;     144.93214108560912	;     157.01231283691277	;     182.51017071182952	;     209.42642026992959	;     261.78090784236360	;     314.10690548141946	;     366.41442316368955	;     418.78178070602792	;     471.23889803846896	;     523.59877559829886	;     578.57664703612022	;     633.55451847394170		]; 
engine.fuel_map_torque_Nm = [	    -85.155000000000030	;    -64.602500000000020	;    -44.049999999999997	;    -27.071249999999999	;    -10.369034090909091	;     6.3331818181818180	;     19.656666666666666	;     32.707884615384614	;     51.486666666666665	;     58.200000000000003	;     63.189999999999998	;     71.528214285714284	;     86.925833333333344	;     99.700000000000003	;     105.44000000000000	;     117.28900000000000	;     131.69999999999999	;     142.77875000000000	;     166.37500000000000	;     187.68093750000000	;     208.98687500000000	;     228.09999999999999	;     247.95071428571430	;     267.80142857142857	;     286.63999999999999	;     298.60000000000002	;     318.45555555555552	;     341.33571428571429	;     361.94999999999999	;     398.07535725000002	;     434.20071450000006		]; 
engine.fuel_map_gps = [
   0.30025968942565107	   0.21337099680439406	   0.12014457615796699	  0.044522574792213818	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	;
   0.22441959096393935	   0.17725752337061829	   0.13332306854139370	   0.10273631261707948	  0.073194063062335016	  0.054700432041421200	  0.028445159474711570	 0.0022147147911378128	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	 0.0057174190487918825	  0.030337654264211832	  0.022058604526274811	   0.00000000000000000	   0.00000000000000000	   0.00000000000000000	;
   0.16464940907058670	   0.14798216014481630	   0.13866757729190693	   0.14233661608727843	   0.14992136036054024	   0.16077900419572302	   0.18250658967270272	   0.19938230688649974	   0.21070010222814350	   0.21375589106097939	   0.17880426886095732	   0.26997929365035955	   0.37193564917903066	   0.48253797923340630	   0.57801447971740982	   0.63051790477427039	   0.64493119637958218	   0.63889645741112544	   0.62631114974402680	;
   0.13177103281267169	   0.14069020416642219	   0.14822211538111879	   0.15629032380829275	   0.17692621801660316	   0.20952090066080595	   0.27394217403441390	   0.33934702848180032	   0.39501470038313302	   0.47681581651339522	   0.48321451185069092	   0.53879224745943399	   0.68755639570867866	   0.87060476327630798	    1.0285078798318963	    1.1275723991856399	    1.1919637141521333	    1.2456876430665802	    1.2960646569198560	;
   0.10765010695415032	   0.14951268472004808	   0.19175665209439086	   0.22965964227399141	   0.27626506645579135	   0.31229563929723986	   0.37203071478993466	   0.43614145978770491	   0.49445120770748319	   0.60193702344916100	   0.66693789435435957	   0.77157814158851823	   0.97492013337541816	    1.2465358015704584	    1.4642622336195039	    1.6074303294728285	    1.7266765238022410	    1.8457448652772304	    1.9636814671496865	;
  0.088459002392222263	   0.16811623839231957	   0.24792262386282427	   0.29199450770605406	   0.33246241300224522	   0.36413836563774926	   0.42874040557291709	   0.49988860266652668	   0.56394354096187438	   0.68709163359800252	   0.77847495622042517	   0.97506264437681767	    1.2349809185600702	    1.6121224902954809	    1.8794316391316204	    2.0741646776804687	    2.2591688210150136	    2.4515878108892761	    2.6436801210982392	;
  0.074020417533113919	   0.17588530754968784	   0.27209846128342380	   0.33390424637962185	   0.37986874360174505	   0.41298375653742392	   0.49139151613168502	   0.57318945717245151	   0.64549394412650341	   0.77726714147372555	   0.89371234433762581	    1.1332324832586209	    1.4297565392450700	    1.8853959088274184	    2.1839626379777286	    2.4381310603659463	    2.6844041020430791	    2.9406271371351820	    3.1965986738520291	;
  0.059079661277728887	   0.18150468271107659	   0.30388510852867445	   0.39720693623054149	   0.48173839553684394	   0.52477647435103558	   0.59456726162353257	   0.66192649727774000	   0.72398950673880036	   0.86686383530979150	    1.0134030657407118	    1.2894200806068459	    1.6284039335046301	    2.1185429415813752	    2.4691795615581213	    2.7912614069058432	    3.1027669117889949	    3.4252962859126503	    3.7476582713549083	;
  0.037910341121836659	   0.19518824483803032	   0.35222450663474830	   0.46745863261918397	   0.57663658091776815	   0.63949769297564263	   0.72607045883569066	   0.80559606700901765	   0.87576208768004182	    1.0268853240760567	    1.1891347017547256	    1.5185506757125544	    1.9377428602213780	    2.4487558720432490	    2.8745743231183596	    3.3015888334227745	    3.7119124659517335	    4.1372359114425992	    4.5634769327608407	;
  0.031090153647226577	   0.20191677717081255	   0.37247502702590274	   0.49607200808445495	   0.61086498239342490	   0.67908229789364216	   0.77249121463421488	   0.85945368305842240	   0.93569049510547342	    1.0910570276685518	    1.2589979085743530	    1.6121482428892062	    2.0518986344298664	    2.5856100966788365	    3.0290880871351145	    3.4880811348108285	    3.9325108131649698	    4.3961391619707806	    4.8614268518053834	;
  0.026179478377654882	   0.20717610473003992	   0.38796693325941684	   0.51808747918267428	   0.63699849002419295	   0.70800919069201462	   0.80648737956602512	   0.89951608453725684	   0.98107703225147613	    1.1395177580791023	    1.3122568598687803	    1.6841748666242504	    2.1375578682558682	    2.6908048515967340	    3.1478260108921909	    3.6274807333873387	    4.0970012076791571	    4.5893393840461112	    5.0839356882943294	;
  0.018391918284384762	   0.21644556711558768	   0.41457935657809120	   0.55645242822878938	   0.68255766915001814	   0.75652533976393399	   0.86258972864541616	   0.96579876904942707	    1.0565046390788406	    1.2222860772758222	    1.4044676345385674	    1.8109638846105791	    2.2834478441870742	    2.8740410601592581	    3.3526102357478416	    3.8622182176985569	    4.3731352421300516	    4.9139480366641628	    5.4580935393711405	;
 0.0072375201598512979	   0.23577302494377583	   0.46498277739812155	   0.62984363839386803	   0.77794264849783346	   0.85764028226210554	   0.97254300436712138	    1.0850952564040803	    1.1850224647809977	    1.3770512304804483	    1.5948507804855587	    2.0936684886380261	    2.5854334629932794	    3.2457546341382657	    3.7526126018031110	    4.3061294209365801	    4.8921228044458598	    5.5251817668920395	    6.1635802536674591	;
 0.0033881637317380430	   0.25453903301886099	   0.50667988618782078	   0.68917766067957009	   0.85496367962307473	   0.95034709964040698	    1.0771547619439259	    1.1926483959103860	    1.2941188656725644	    1.5083427737796153	    1.7514682477068146	    2.3082117656286285	    2.8597852162836443	    3.5612623851562604	    4.0878355035534000	    4.6843921800895858	    5.3369456000023874	    6.0492243357739115	    6.7674158051269071	;
 0.0029102051574690672	   0.26377887537298111	   0.52567743420935342	   0.71616204146562890	   0.89063521509367061	   0.99119165201826986	    1.1239475103622691	    1.2427720707890442	    1.3464835622786526	    1.5666458423614273	    1.8207108217009120	    2.4040305145082508	    2.9818207488532269	    3.6960843562602097	    4.2359529555351783	    4.8559992462744841	    5.5401131875159768	    6.2884285694468049	    7.0425471037325709	;
 0.0043515285722184761	   0.28470017308974538	   0.56587755487147073	   0.77249748251475148	   0.96515883292414140	    1.0748362288810729	    1.2195210019257288	    1.3481849092555407	    1.4594842063823632	    1.6848581322983029	    1.9595121324225253	    2.6042468615141083	    3.2291670574750944	    3.9671353029600342	    4.5353362336884784	    5.2132268155802182	    5.9659494985291506	    6.7894070894057643	    7.6177039044198027	;
  0.012792006235790510	   0.31700071753296255	   0.62081977044885295	   0.84155151538491002	    1.0462860242167160	    1.1656887717013147	    1.3248962671910456	    1.4689223428061526	    1.5932274803583015	    1.8344471774651381	    2.1178411959553949	    2.7973152808546020	    3.5276695704400520	    4.2806599780634764	    4.8860829406511339	    5.6565975744107959	    6.5022319046356207	    7.4187656444310370	    8.3372215764714230	;
  0.023912253648232358	   0.34669853377343274	   0.66902303023877097	   0.90123284958818162	    1.1137364732488242	    1.2380323987222923	    1.4054028799176947	    1.5557321322328810	    1.6850916745207960	    1.9486593646930224	    2.2422106317366537	    2.9398834259083624	    3.7347372131790011	    4.4929276055961740	    5.1571122153887563	    6.0052194885079953	    6.9276821331487044	    7.9167134197918250	    8.9050839640941710	;
  0.065642618150043436	   0.42556571678817151	   0.78988960921934914	    1.0558232013668185	    1.2957713624380052	    1.4294684986631090	    1.6050806187607349	    1.7668948312714701	    1.9091514706909960	    2.2031098779680289	    2.5372982671963884	    3.2324528556669652	    4.0609016780927272	    4.9012441580266968	    5.7431452068013282	    6.7775306781499944	    7.8817021432607604	    9.0287901189417337	    10.173058497009727	;
   0.13163533939116914	   0.51062026354112999	   0.88953518938080189	    1.1650383904527002	    1.4188945724973461	    1.5662098553361838	    1.7626023265026416	    1.9415807746165983	    2.0991236940417353	    2.4341712262364315	    2.7946057253861603	    3.5234185620055531	    4.3755742255956704	    5.2990573542135282	    6.3140415907342682	    7.4963124761064277	    8.7857696181904714	    10.089589721113047	    11.408361670364169	;
   0.21104374757762981	   0.61163122508989776	    1.0067448080553383	    1.2879284184544717	    1.5475252670319071	    1.7031343377062775	    1.9180358333068810	    2.1161479834284087	    2.2910417856762284	    2.6604870896590480	    3.0580070542480322	    3.8404568075429544	    4.7504472380700005	    5.7302981485561162	    6.8754530230013895	    8.2026403048054526	    9.6722074431547895	    11.186156308302667	    12.727369152976637	;
   0.28352091895105236	   0.71035878609422942	    1.1391169693387329	    1.4450943129806146	    1.7101905318180801	    1.8680499751163984	    2.0830888149117652	    2.2839935606142054	    2.4639988847699188	    2.8580875383737756	    3.2871537833983098	    4.1565690810395655	    5.1152121670603581	    6.1342149487771902	    7.3700753649368780	    8.8284833732886838	    10.454077605871118	    12.205539860089283	    13.976565227822284	;
   0.36289478954430243	   0.81091709649449695	    1.2584515396552116	    1.5784166199124421	    1.8678166877667510	    2.0395469207545323	    2.2763510975481180	    2.4919156703638867	    2.6807117320598679	    3.0833743294731906	    3.5310230584700686	    4.4757656485672817	    5.4810640270510937	    6.5645687432260607	    7.8860761060187654	    9.5061580226590507	    11.325747359517230	    13.321666084005718	    15.330736570575692	;
   0.44541637090091651	   0.92338409113621756	    1.4053023417551043	    1.7690014754656400	    2.1210090788807658	    2.3332912074921919	    2.6063395672029026	    2.7951981340629897	    2.9478137520952838	    3.3103912822361448	    3.7688755296878091	    4.7295293743963773	    5.7467066136002227	    6.9491521229915971	    8.4304169150432333	    10.271374882942130	    12.309403817660241	    14.520500674354436	    16.732196759230725	;
   0.52653818806285790	    1.0644248148951059	    1.6038733800172333	    1.9977779156055122	    2.3672964444097260	    2.5942076146241835	    2.8783980906291111	    3.0851829449535093	    3.2490274524336278	    3.5792870863660760	    4.0011423100057399	    4.9728777692492896	    5.9855758666357577	    7.2633914000566788	    9.0317732659715890	    11.137034737449016	    13.374288254148082	    15.741235444072444	    18.091754155094833	;
   0.57615879085117194	    1.1609697032176880	    1.7487468268033144	    2.1784283385026932	    2.5716494561713144	    2.7929792773678441	    3.0684887798446621	    3.2824425460686815	    3.4522865655574697	    3.7699071227960692	    4.1720444296968475	    5.1691275701769648	    6.2163690742719773	    7.5016972890917613	    9.4914150929530603	    11.764052452605494	    14.108074144795246	    16.547409072240615	    18.961750792347072	;
   0.65048460708901035	    1.3222700571235086	    1.9930938242199574	    2.4700236743186403	    2.8920478130487592	    3.1269865281692830	    3.4262344038617263	    3.6816627071133952	    3.8924579496333118	    4.2634020633699405	    4.6000057433149379	    5.5705962972131813	    6.7248999921175105	    8.0514087857389800	    10.452932454667152	    12.958338480128695	    15.424797799216821	    17.934174850821549	    20.413952598595877	;
   0.69435468840056147	    1.4616772604106298	    2.2213168859809267	    2.7577909619713763	    3.2354094893858631	    3.5051904283350646	    3.8544533405434978	    4.1620760906822953	    4.4262788697234656	    4.9628728539134821	    5.4936906216826840	    6.7619001227305304	    8.5407587761353465	    9.4983250773295183	    12.142602277909907	    14.671354999444624	    17.101083412158467	    19.601388640111800	    22.096162548252515	;
   0.67101637470665243	    1.5322876619112833	    2.3864621380009594	    2.9954248542295594	    3.5450692324118340	    3.8596007034936366	    4.2716683638462625	    4.6412649486034709	    4.9643061370606878	    5.6484298350607753	    6.3887887841626734	    7.9828592106046745	    9.8896337311054179	    11.308688810985768	    14.071603745208025	    16.359922474478921	    18.678784626993984	    21.142140333665523	    23.621062691130657	;
   0.44392845332999964	    1.5292365624416191	    2.6165673197842203	    3.4062741670167664	    4.1310592236820192	    4.5504110975495156	    5.1042264240354616	    5.6052667837918726	    6.0456588640806705	    6.9861378918857229	    8.0016221642394800	    10.065352059526155	    12.228569682202970	    14.473160549076171	    16.902849837748921	    19.245804926961920	    21.528689069830978	    23.923181294275714	    26.328562634294016	;
  0.090367071634569834	    1.4612526120255784	    2.8373636710685282	    3.8389801790865392	    4.7590002583543427	    5.2911496961268210	    5.9934692951308453	    6.6278879447762762	    7.1845517929763378	    8.3681798314925970	    9.6335835726313022	    12.152505846824772	    14.718786667920527	    17.279651545683929	    19.733339830754424	    22.098960017095848	    24.386699754402340	    26.740845545612466	    29.077528220249548	]; 
engine.deac_fuel_map_gps = [
                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	;
                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	;
                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	;
                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	;
                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	;
                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	   0.56793115334516109	   0.75262802936286977	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	;
                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	   0.42289415080965459	   0.48671104931726228	   0.54169693040789568	   0.63524229444748270	   0.72532585802629423	   0.93700021416494594	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	;
                   NaN	                   NaN	                   NaN	                   NaN	   0.39052474546412252	   0.44718457382547705	   0.52287650174249034	   0.59374731746286502	   0.65464980425893116	   0.76944188608764963	   0.88062544418193345	    1.1161159293800760	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	;
                   NaN	                   NaN	                   NaN	                   NaN	   0.50483171683215022	   0.56987317488442002	   0.65680453463341248	   0.73515106795216190	   0.80295468043337614	   0.94158175462717542	    1.0828234068894231	    1.3755500462577017	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	;
                   NaN	                   NaN	                   NaN	                   NaN	   0.54529686889621587	   0.61164434961939296	   0.70135875958910954	   0.78474224019741634	   0.85757089506361739	    1.0027518328790122	    1.1504044203473098	    1.4703085550669424	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	;
                   NaN	                   NaN	                   NaN	                   NaN	   0.57586186629368685	   0.64280560596037972	   0.73390149203892818	   0.82132414540641852	   0.89837435146787792	    1.0482691605367249	    1.2001986609765689	    1.5411644795452810	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	;
                   NaN	                   NaN	                   NaN	                   NaN	   0.62887963117872037	   0.69623432623717996	   0.78864168443906635	   0.88178796716173058	   0.96470501087360205	    1.1245926740925354	    1.2836828800022180	    1.6605586070340375	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	;
                   NaN	                   NaN	                   NaN	                   NaN	   0.74520362069104551	   0.80962170369433872	   0.89712250328407694	   0.99563603420413715	    1.0863625240344068	    1.2708727532978128	    1.4613593582614399	    1.8857136055091861	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	;
                   NaN	                   NaN	                   NaN	                   NaN	   0.82509686578269847	   0.90300719199854784	    1.0078140649214538	    1.1086988768236674	    1.2006226327629530	    1.4043620554623342	    1.6274604334464695	    2.0786303067856502	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	;
                   NaN	                   NaN	                   NaN	                   NaN	   0.85718215485579796	   0.94152765573374697	    1.0544461604322664	    1.1600338469440969	    1.2552699123869868	    1.4667207827923394	    1.7012267620180350	    2.1661945451071514	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	;
                   NaN	                   NaN	                   NaN	                   NaN	   0.92412528692803697	    1.0190431990057842	    1.1471709106078349	    1.2665803390040100	    1.3723338889632044	    1.5987562642920607	    1.8478751983461108	    2.3480123706206744	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	;
                   NaN	                   NaN	                   NaN	                   NaN	    1.0335124473456776	    1.1374357687568670	    1.2768367997726984	    1.4060132299491721	    1.5201023029382925	    1.7611521144293512	    2.0209830713809285	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	;
                   NaN	                   NaN	                   NaN	                   NaN	    1.1137364732488242	    1.2380323987222923	    1.3858498146377662	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	;
                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	;
                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	;
                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	;
                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	;
                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	;
                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	;
                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	;
                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	;
                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	;
                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	;
                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	;
                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	;
                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	                   NaN	]; 

% Fuel Properties
engine.fuel = class_REVS_fuel('FTAG 24670');

% Idle Speed
engine.idle_speed_radps = class_REVS_dynamic_lookup;
engine.idle_speed_radps.axis_1.signal =  'veh_spd_mps'; 
engine.idle_speed_radps.axis_1.breakpoints = [	    0.00000000000000000	    1.0000000000000000	    5.0000000000000000	    100.00000000000000		]; 
engine.idle_speed_radps.table = [	     58.643062867009469	    62.831853071795862	    63.879050622992459	    63.879050622992459		]; 

% Pedal Calibration
engine.pedal_map_type = enum_engine_pedal_map_type.max_engine_power;

% Calibration Adjustment Factors
engine.deac_transition_on_duration_secs =  1; 
engine.deac_transition_off_duration_secs =  0.1; 
engine.deac_transition_off_fuel_multiplier = [	     1.8000000000000000	    1.0000000000000000		]; 
engine.deac_transition_off_fuel_multiplier_time_secs = [	    0.00000000000000000	    2.0000000000000000		]; 
engine.DFCO_min_duration_secs =  2; 
engine.DFCO_refuel_multiplier = [	     1.0000000000000000	    2.0000000000000000	    1.0000000000000000		]; 
engine.DFCO_refuel_multiplier_time_secs = [	    0.00000000000000000	   0.10000000000000001	    2.0000000000000000		]; 
